%{
/* cleanup later - put free($?) for all arguments that are strings */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "global.h"
#include "agent.h"
#include "field.h"
#include "utils.h"
#include "attribute.h"
#include "evolve.h"
#include "display.h"
#include "routine_composite.h"
#include "info_aqui.h"

int error_encountered=0;

int verbose=0;

AGENTCLASS *current_agentclass=NULL;
FIELD      *current_field=NULL;
ATTRIBUTE  *current_attribute=NULL;
EVOLUTION_RULE *current_rule=NULL;
ROUTINE    *current_routine=NULL;
DISPLAY    *current_display=NULL;
STAT_FIELD *current_stat_field=NULL;

int yylex(void);
void yyerror(char *string);
void init_values(u64 i);
void free_values(void);
void add_value(u64 i);

struct {
	u64 *values;
	int values_free;
	int values_size;
	} value_list;


%}

%union {
char * string;
u64	value;
struct {
	long x1;
	long y1;
	long x2;
	long y2;
	} rect;
ATTRIBUTE_PARAM param;	
OPT * opt;
}


%token <value> T_AGENTCLASS
%token 	<value> T_END
%token <value> T_ATTRIBUTE
%token <string> T_STRING
%token <value> T_VALUE
%token <value> T_WHITESPACE
%token <value> T_FIELD
%token <value> T_DIMENSIONS
%token <value> T_PAINT
%token <value>  T_RECT
%token <value>  T_CIRCLE
%token <value>  T_TIME
%token <value> T_INT
%token <value> T_BOOL
%token <value> T_SET
%token <value> T_REPERTOIRE
%token <value> T_DEFAULT
%token <value> T_WALK
%token <value> T_JUMP
%token <value> T_TYPE
%token <value> T_SIZE
%token <value> T_BIAS_MIN
%token <value> T_BIAS_VOL
%token <value> T_BIAS_MAX
%token <value> T_LARGEST
%token <value> T_SMALLEST
%token <value> T_RANDOM
%token <value> T_CONDITION
%token <value> T_RULE
%token <value> T_BECOMES
%token <value> T_ROUTINE
%token <value> T_FROM
%token <value> T_STATISTICS
%token <value> T_SUM
%token <value> T_BIAS
%token <value> T_DISTRIBUTION
%token <value> T_FILE
%token <value> T_VIEW
%token <value> T_COLOR1
%token <value> T_COLOR2
%token <value> T_COLOR3
%token <value> T_PARAMETERS
%token <value> T_COMMENT
%token <value> T_COMPOSITE
%token <value> T_ALL
%token <opt> T_CODE


%token <value> T_LPARAN
%token <value> T_RPARAN
%token <value> T_OPT2
%token <value> T_OPT1
%token <value> T_QM
%token <value> T_COLON

%token <string> T_FN
%token <string> T_AT

%type <value> random_param_set
%type <param> attribute_directives_value
%token <value> routine_value
%type <opt> routine_code

%%

input:	input_statement input 		{}
	| input_statement		{}
	| error				{yyclearin; yyerrok; YYABORT;}
;


input_statement: T_WHITESPACE		{}
		| agentclass_statement 	{}
		| field_statement	{}
		| attribute_statement   {}
		| rule_statement	{}
		| routine_statement     {}
		| view_statement	{}
		| statistics_statement  {}
		| T_TIME T_WHITESPACE T_VALUE	{ set_time($3); }
;

random_param_set: random_param_set T_WHITESPACE   {$$=$1}
	|random_param_set T_VALUE  {	
		$$=$1 | (((u64)1)<<$2);
		}
	| T_VALUE  {
		$$=(((u64)1)<<$1);
		}
	| random_param_set T_ALL {
		$$=$1 | (~((u64)0));
		}
	| T_WHITESPACE   { $$=0; }
;	


attribute_directives_value: attribute_directives_value T_VALUE {	
				memcpy(&($$),&($1),sizeof(ATTRIBUTE_PARAM));
				$$.value=$2;
				}
			| attribute_directives_value T_WHITESPACE {
				memcpy(&($$),&($1),sizeof(ATTRIBUTE_PARAM));
				}
			| attribute_directives_value T_SIZE T_WHITESPACE T_VALUE {
				memcpy(&($$),&($1),sizeof(ATTRIBUTE_PARAM));
				$$.param.set.size=$4;
				}
			| attribute_directives_value T_RANDOM random_param_set{
				memcpy(&($$),&($1),sizeof(ATTRIBUTE_PARAM));
				$$.random=1;
				$$.param.set.mask_random=$3;
				$$.param.rep.mask_in=0;
				$$.param.rep.activated=-1;
				}
			| T_WHITESPACE {
				$$.random=0;
				$$.value=0;
				}
;				


attribute_directive1: T_ATTRIBUTE T_WHITESPACE T_STRING  attribute_directives_value {  
		if(current_agentclass==NULL){
			fprintf(stderr,"Invalid attribute directive\n");
			}else{
			set_agentclass_attr_param_value(current_agentclass,$3,&($4));
			if(verbose>10)printf("attribute_directive \"%s\"\n",$3);
			free($3);
			}
		}		
;

agentclass_directive: T_WHITESPACE	{}
		| attribute_directive1	{}
;

agentclass_rules: agentclass_rules agentclass_directive {}
		| agentclass_directive 	{}
;

agentclass_header: T_AGENTCLASS T_WHITESPACE T_STRING	{
		if(verbose>10)printf("agentclass_header \"%s\"\n",$3);
		current_agentclass=add_new_agentclass($3);
		free($3);
		}
;		

agentclass_statement: agentclass_header agentclass_rules T_END	 { 
		if(verbose>10)printf("agentclass_statement_complete\n");
		current_agentclass=NULL;
		}
;

field_header: T_FIELD T_WHITESPACE T_STRING T_WHITESPACE T_DIMENSIONS T_WHITESPACE T_VALUE T_WHITESPACE T_VALUE {
		if(verbose>10)printf("field_header \"%s\"\n",$3);
		current_field=add_new_field($3,$7,$9);
		free($3);
		}
;

paint_rectangle_directive: T_PAINT T_WHITESPACE T_STRING T_WHITESPACE T_RECT T_VALUE T_VALUE T_VALUE T_VALUE T_WHITESPACE T_VALUE {
		if(verbose>10)printf("rectangle_directive\n");
		if(current_field!=NULL)
			add_rect_seeding_command(current_field,$3,$6,$7,$8,$9,$11);
		free($3);
		}
;

paint_circle_directive: T_PAINT T_WHITESPACE T_STRING T_WHITESPACE T_CIRCLE T_VALUE T_VALUE T_VALUE  T_WHITESPACE T_VALUE {
		if(verbose>10)printf("circle_directive\n");
		if(current_field!=NULL)
			add_circle_seeding_command(current_field,$3,$6,$7,$8,$10);
		free($3);
		}
;

paint_directive: paint_rectangle_directive {}
		| paint_circle_directive   {}
;

field_directive: T_WHITESPACE		{}
		| paint_directive 	{}
;

field_directives: field_directives field_directive  {}                		   
		| field_directive 		   {}
;		

field_statement: field_header field_directives T_END {
		if(verbose>10)printf("field_statement_complete\n");
		current_field=NULL;
		}
;


attribute_header: T_ATTRIBUTE T_WHITESPACE T_STRING {
		if(verbose>10)printf("attribute_header \"%s\"\n",$3);
		current_attribute=add_new_attribute($3);
		}
;		


attribute_directive: T_TYPE T_WHITESPACE T_BOOL { 
				if(current_attribute!=NULL)
					current_attribute->type=TYPE_BOOL;
				}
		 | T_TYPE T_WHITESPACE T_INT { 
				if(current_attribute!=NULL)
					current_attribute->type=TYPE_INT;
				}
		 | T_TYPE T_WHITESPACE T_SET { 
				if(current_attribute!=NULL)
					current_attribute->type=TYPE_INT;
				}
		 | T_TYPE T_WHITESPACE T_REPERTOIRE { 
				if(current_attribute!=NULL){
					current_attribute->type=TYPE_REPERTOIRE;
					}
				}
		 | T_DEFAULT T_WHITESPACE T_VALUE { 
				if(current_attribute!=NULL)
					current_attribute->default_value=$3;
				}
		 | T_WALK	{
		 		if(current_attribute!=NULL)
					current_attribute->param.rep.walk_bias=1;
				}
		 | T_JUMP	{
		 		if(current_attribute!=NULL)
					current_attribute->param.rep.walk_bias=0;
				}
		 | T_LARGEST T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.integer.largest=$3;
				}		
		 | T_SMALLEST T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.integer.largest=$3;
				}		
		 | T_SIZE T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.set.size=$3;
				}
		 | T_BIAS_MIN T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.rep.bias_min=$3;
				}
		 | T_BIAS_VOL T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.rep.bias_vol=$3;
				}
		 | T_BIAS_MAX T_WHITESPACE T_VALUE {
		 		if(current_attribute!=NULL)
					current_attribute->param.rep.bias_max=$3;
				}
;				

attribute_directives: attribute_directives T_WHITESPACE attribute_directive {}
		| attribute_directive				{}
;

attribute_statement: attribute_header T_WHITESPACE attribute_directives T_WHITESPACE T_END {
		if(verbose>10)printf("attribute_statement_complete\n");
		if(current_attribute->type==TYPE_REPERTOIRE){
			current_attribute->param.rep.bias_values=NULL;
			current_attribute->param.rep.data1=NULL;
			init_bias_values(&(current_attribute->param.rep));
			}
		current_attribute=NULL;
		}
;		

rule_header:  T_RULE T_WHITESPACE T_STRING T_WHITESPACE T_BECOMES T_WHITESPACE T_STRING {
		if(verbose>10)printf("rule_header \"%s\" \"%s\"\n",$3,$7);
		current_rule=add_new_rule($3,$7);
		}
;

rule_directive:  T_CONDITION T_WHITESPACE T_STRING {
			if(verbose>10)printf("condition \"%s\"\n",$3);
			if(current_rule!=NULL)
				set_rule_condition(current_rule,$3);
			}
		| T_ATTRIBUTE T_WHITESPACE T_STRING T_WHITESPACE T_STRING {
			if(verbose>10)printf("attribute \"%s\" \"%s\"\n",$3,$5);
			if(current_rule!=NULL)
				set_rule_evolve_attr(current_rule,$3,$5);
			}
;

rule_directives: rule_directives T_WHITESPACE rule_directive  { }
	| rule_directive {}
;	

rule_statement: rule_header T_WHITESPACE rule_directives T_WHITESPACE T_END {
		if(verbose>10)printf("rule_statement_complete\n");
		current_rule=NULL;
		}
;

routine_customized_header: T_ROUTINE T_WHITESPACE T_STRING T_WHITESPACE T_FROM T_WHITESPACE T_STRING  {
		if(verbose>10)printf("routine_header \"%s\" \"%s\"\n",$3,$7);
		current_routine=add_new_customized_routine($3,$7);
		free($3);
		free($7);
		}
;

routine_comment: T_COMMENT T_WHITESPACE T_STRING {
		if(current_routine!=NULL){
				if(current_routine->comment!=NULL)free(current_routine->comment);
				current_routine->comment=strdup($3);
				}
		free($3);
		}
;

routine_values: routine_values T_WHITESPACE T_VALUE {
		add_value($3);	
		}
		| routine_values T_WHITESPACE T_STRING {
		add_value(get_attribute_index($3));
		free($3);
		}
		| routine_values T_WHITESPACE T_AT {
		add_value(get_attribute_index($3));
		free($3);
		}
		| routine_values T_WHITESPACE T_FN {
		add_value(get_routine_index($3));
		free($3);
		}
		| T_VALUE     {
		init_values($1);
		}
		| T_STRING {
		init_values(get_attribute_index($1));
		free($1);
		}
		| T_AT {
		init_values(get_attribute_index($1));
		free($1);
		}
		| T_FN {
		init_values(get_routine_index($1));
		free($1);
		}
;		


routine_customized: routine_customized_header T_WHITESPACE T_PARAMETERS T_WHITESPACE routine_values T_WHITESPACE T_END {
		if(current_routine!=NULL){
			memcpy(current_routine->param_type,value_list.values,current_routine->param_count*sizeof(u64));
			}
		free_values();
		}
                | routine_customized_header T_WHITESPACE routine_comment T_WHITESPACE T_PARAMETERS T_WHITESPACE routine_values T_WHITESPACE T_END {
		if(current_routine!=NULL){
			memcpy(current_routine->param_type,value_list.values,current_routine->param_count*sizeof(u64));
			}
		free_values();
		}
                | routine_customized_header T_WHITESPACE T_PARAMETERS T_WHITESPACE routine_values T_WHITESPACE routine_comment T_WHITESPACE T_END {
		if(current_routine!=NULL){
			memcpy(current_routine->param_type,value_list.values,current_routine->param_count*sizeof(u64));
			}
		free_values();
		}
;




routine_header_composite: T_ROUTINE T_WHITESPACE T_STRING T_WHITESPACE T_COMPOSITE {
		if(verbose>10)printf("routine_header \"%s\"\n",$3);
		current_routine=add_new_composite_routine($3);
		free($3);
		}
;		


routine_comment: T_COMMENT T_WHITESPACE T_STRING {
	if(current_routine!=NULL){
		if(current_routine->comment!=NULL)free(current_routine->comment);
		current_routine->comment=$3;
		}
	}
;	


routine_code: T_VALUE {
	$$=do_alloc(1,sizeof(OPT));
	$$->value=$1;
	$$->type=OPT_CI;
	}
	|T_AT {
	$$=do_alloc(1,sizeof(OPT));
	$$->value=get_attribute_index($1);
	$$->type=OPT_AT;
	}	
	|T_FN {
	$$=do_alloc(1,sizeof(OPT));
	$$->value=get_routine_index($1);
	$$->type=OPT_FN;
	}	
	| T_LPARAN routine_code T_RPARAN {
	$$=$2;
	}
	| routine_code T_OPT2 routine_code {
	$$=do_alloc(1,sizeof(OPT));
	$$->type=$2;
	$$->param1=$1;
	$$->param2=$3;
	}
	| T_OPT1 routine_code {
	$$=do_alloc(1,sizeof(OPT));
	$$->type=$1;
	$$->param1=$2;
	}
	| routine_code T_QM routine_code T_COLON routine_code {
	$$=do_alloc(1,sizeof(OPT));
	$$->type=OPT_IF;
	$$->param1=$1;
	$$->param2=$3;
	$$->param3=$5;
	}	
;	

routine_code_directive: T_CODE routine_code  {
		if(current_routine!=NULL){
			current_routine->data=(void *)$2;
			}
		}
;

routine_composite: routine_header_composite T_WHITESPACE routine_comment T_WHITESPACE routine_code_directive T_WHITESPACE T_END{
	}
	|  routine_header_composite T_WHITESPACE routine_code_directive T_WHITESPACE T_END{
	}
;	

routine_statement: routine_customized {
		if(verbose>10)printf("routine_statement_complete\n");
		current_routine=NULL;
		}
		| routine_composite {
		if(verbose>10)printf("routine_statement_complete\n");
		current_routine=NULL;
		}
;

view_header: T_VIEW T_WHITESPACE T_STRING  {
	if(verbose>10)printf("view_header \"%s\"\n",$3);
	current_display=add_new_display($3);
	free($3);
	}
;	

view_comment: T_COMMENT T_WHITESPACE T_STRING {
		if(current_display!=NULL){
			if(current_display->comment!=NULL)free(current_display->comment);
			current_display->comment=strdup($3);
			}
		free($3);
		}
;		

view_type: T_TYPE T_WHITESPACE T_STRING {
		if(current_display!=NULL){
			if(current_display->type!=NULL)free(current_display->type);
			current_display->type=strdup($3);
			current_display->routine_type=get_routine_index($3);
			}
		free($3);
		}
;		

view_color1: T_COLOR1 T_WHITESPACE T_STRING {
		if(current_display!=NULL){
			if(current_display->color1!=NULL)free(current_display->color1);
			current_display->color1=strdup($3);
			current_display->routine_index1=get_routine_index($3);
			}
		free($3);
		}
;

view_color2: T_COLOR2 T_WHITESPACE T_STRING {
		if(current_display!=NULL){
			if(current_display->color2!=NULL)free(current_display->color2);
			current_display->color2=strdup($3);
			current_display->routine_index2=get_routine_index($3);
			}
		free($3);
		}
;		

view_color3: T_COLOR3 T_WHITESPACE T_STRING {
		if(current_display!=NULL){
			if(current_display->color3!=NULL)free(current_display->color3);
			current_display->color3=strdup($3);
			current_display->routine_index3=get_routine_index($3);
			}
		free($3);
		}
;		

view_directives:  view_comment {}
	| view_type   {}
	|  view_color1  {}
	|  view_color2 {}
	| view_color3 {}
	| view_directives T_WHITESPACE view_comment {}
	| view_directives T_WHITESPACE view_type {}
	| view_directives T_WHITESPACE view_color1 {}
	| view_directives T_WHITESPACE view_color2 {}
	| view_directives T_WHITESPACE view_color3 {}
;

view_statement: view_header T_WHITESPACE view_directives T_WHITESPACE T_END {
	if(verbose>10)printf("view_statement_complete\n");
	current_display=NULL;
	}
;


statistics_header: T_STATISTICS {}
;

statistics_directive: T_FILE T_WHITESPACE T_STRING  { set_filename($3); free($3);}
	|	T_BIAS T_WHITESPACE T_STRING T_WHITESPACE T_STRING {
		current_stat_field=add_new_stat($3);
		current_stat_field->type=TYPE_BIAS;
		current_stat_field->routine_name=strdup($5);
		current_stat_field->routine_index=get_attribute_index($5);
		free($3);
		free($5);
		current_stat_field=NULL;
		}
	|	T_SUM T_WHITESPACE T_STRING T_WHITESPACE T_STRING T_WHITESPACE T_STRING{
		current_stat_field=add_new_stat($3);
		current_stat_field->type=TYPE_SUM;
		current_stat_field->condition=strdup($5);
		current_stat_field->condition_index=get_routine_index($5);
		current_stat_field->routine_name=strdup($7);
		current_stat_field->routine_index=get_routine_index($7);
		free($3);
		free($5);
		free($7);
		current_stat_field=NULL;
		}
	|	T_DISTRIBUTION T_WHITESPACE T_STRING T_WHITESPACE T_VALUE T_WHITESPACE T_STRING T_WHITESPACE T_STRING{
		current_stat_field=add_new_stat($3);
		current_stat_field->type=TYPE_DISTRIBUTION;
		current_stat_field->max_size=$5;
		if(current_stat_field->max_size<=0)current_stat_field->max_size=1;
		current_stat_field->condition=strdup($7);
		current_stat_field->condition_index=get_routine_index($7);
		current_stat_field->routine_name=strdup($9);
		current_stat_field->routine_index=get_routine_index($9);
		current_stat_field->data1=do_alloc(current_stat_field->max_size,sizeof(u64));
		free($3);
		free($7);
		free($9);
		current_stat_field=NULL;
		}
;

statistics_directives: statistics_directives T_WHITESPACE statistics_directive {}
	| statistics_directive {}
;	

statistics_statement: statistics_header T_WHITESPACE statistics_directives T_WHITESPACE T_END {
	if(verbose>10)printf("statistics_statement_complete\n");
	}
;	

%%

void init_values(u64 i)
{
value_list.values=do_alloc(10,sizeof(u64));
value_list.values[0]=i;
value_list.values_free=1;
value_list.values_size=10;
}

void free_values(void)
{
free(value_list.values);
}

void add_value(u64 i)
{
u64 *a;
if(value_list.values_free+1>=value_list.values_size){
	a=do_alloc(value_list.values_size*2,sizeof(u64));
	memcpy(a,value_list.values,value_list.values_free*sizeof(u64));
	free(value_list.values);
	value_list.values=a;
	}
value_list.values[value_list.values_free]=i;
value_list.values_free++;
}

void yyerror(char *string)
{
fprintf(stderr,"conf_reader:%s\n",string);
error_encountered=1;
yyclearin;
}

void yyreset(void)
{
yyclearin;
current_agentclass=NULL;
current_field=NULL;
current_attribute=NULL;
current_rule=NULL;
current_routine=NULL;
current_display=NULL;
current_stat_field=NULL;
}
